<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="/iva">
		<iva>
			<xsl:copy-of select="TipoIDInformante"/>
			<xsl:copy-of select="IdInformante"/>
			<xsl:copy-of select="razonSocial"/>
			<xsl:copy-of select="Anio"/>
			<xsl:copy-of select="Mes"/>
			<xsl:copy-of select="numEstabRuc"/>
			<xsl:copy-of select="totalVentas"/>
			<xsl:copy-of select="codigoOperativo"/>
			<xsl:variable name="anio" select="Anio"/>
			<xsl:variable name="mes" select="Mes"/>
			<xsl:if test="compras">
				<compras>
					<xsl:for-each select="compras/detalleCompras">
						<detalleCompras>
							<xsl:copy-of select="codSustento"/>
							<xsl:copy-of select="tpIdProv"/>
							<xsl:copy-of select="idProv"/>
							<xsl:copy-of select="tipoComprobante"/>
							<xsl:copy-of select="tipoProv"/>
							<xsl:copy-of select="parteRel"/>
							<xsl:copy-of select="fechaRegistro"/>
							<xsl:copy-of select="establecimiento"/>
							<xsl:copy-of select="puntoEmision"/>
							<xsl:copy-of select="secuencial"/>
							<xsl:copy-of select="fechaEmision"/>
							<xsl:copy-of select="autorizacion"/>
							<xsl:copy-of select="baseNoGraIva"/>
							<xsl:copy-of select="baseImponible"/>
							<xsl:copy-of select="baseImpGrav"/>
							<xsl:choose>
								<xsl:when test="baseImpExe != ''">
									<xsl:copy-of select="baseImpExe"/>
								</xsl:when>
								<xsl:otherwise>
									<baseImpExe>0.00</baseImpExe>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:copy-of select="montoIce"/>
							<xsl:copy-of select="montoIva"/>
							<xsl:copy-of select="valRetBien10"/>
							<xsl:copy-of select="valRetServ20"/>
							<xsl:copy-of select="valorRetBienes"/>
							<xsl:choose>
								<xsl:when test="$anio &gt;='2016'">
									<valRetServ50>0.00</valRetServ50>
								</xsl:when>
							</xsl:choose>
							<xsl:copy-of select="valorRetServicios"/>
							<xsl:copy-of select="valRetServ100"/>

							<xsl:choose>
								<xsl:when test="totbasesImpReemb != ''">
									<xsl:copy-of select="totbasesImpReemb"/>
								</xsl:when>
								<xsl:otherwise>
									<totbasesImpReemb>0.00</totbasesImpReemb>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:copy-of select="pagoExterior"/>
							<xsl:copy-of select="formasDePago"/>
							<xsl:copy-of select="air"/>
							<xsl:if test="estabRetencion1 != ''">
								<xsl:if test="not(estabRetencion1 = '000')">
									<estabRetencion1>
										<xsl:value-of select="estabRetencion1"/>
									</estabRetencion1>

									<ptoEmiRetencion1>
										<xsl:value-of select="ptoEmiRetencion1"/>
									</ptoEmiRetencion1>

									<secRetencion1>
										<xsl:value-of select="secRetencion1"/>
									</secRetencion1>
									<xsl:if test="autRetencion1 != ''">
										<autRetencion1>
											<xsl:value-of select="autRetencion1"/>
										</autRetencion1>
									</xsl:if>
									<xsl:if test="not(fechaEmiRet1 = '00/00/0000')">
										<fechaEmiRet1>
											<xsl:value-of select="fechaEmiRet1"/>
										</fechaEmiRet1>
									</xsl:if>
								</xsl:if>
							</xsl:if>

							<xsl:copy-of select="estabRetencion2"/>
							<xsl:copy-of select="ptoEmiRetencion2"/>
							<xsl:copy-of select="secRetencion2"/>
							<xsl:copy-of select="autRetencion2"/>
							<xsl:copy-of select="fechaEmiRet2"/>

							<xsl:copy-of select="docModificado"/>
							<xsl:copy-of select="estabModificado"/>
							<xsl:copy-of select="ptoEmiModificado"/>
							<xsl:copy-of select="secModificado"/>
							<xsl:copy-of select="autModificado"/>
							<xsl:copy-of select="reembolsos"/>
						</detalleCompras>
					</xsl:for-each>
				</compras>
			</xsl:if>
			<xsl:if test="ventas">
				<ventas>
					<xsl:for-each select="ventas/detalleVentas">
						<detalleVentas>
							<xsl:copy-of select="tpIdCliente"/>
							<xsl:copy-of select="idCliente"/>
							<xsl:copy-of select="parteRelVtas"/>
							<tipoComprobante>
								<xsl:choose>
									<xsl:when test="string-length(normalize-space(tipoComprobante)) = 1">
										<xsl:value-of select="concat('0',normalize-space(tipoComprobante))"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="tipoComprobante"/>
									</xsl:otherwise>
								</xsl:choose>
							</tipoComprobante>
							<tipoEmision>F</tipoEmision>
							<xsl:copy-of select="numeroComprobantes"/>
							<baseNoGraIva>
								<xsl:value-of select="format-number(baseNoGraIva, '#0.00')"/>
							</baseNoGraIva>
							<baseImponible>
								<xsl:value-of select="format-number(baseImponible, '#0.00')"/>
							</baseImponible>
							<baseImpGrav>
								<xsl:value-of select="format-number(baseImpGrav, '#0.00')"/>
							</baseImpGrav>
							<montoIva>
								<xsl:value-of select="format-number(montoIva, '#0.00')"/>
							</montoIva>
							<xsl:if test="$anio &gt;'2015'">
								<xsl:choose>
									<xsl:when test="montoIce != ''">
										<montoIce>
											<xsl:value-of select="format-number(montoIce, '#0.00')"/>
										</montoIce>
									</xsl:when>
									<xsl:otherwise>
										<montoIce>0.00</montoIce>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
							<xsl:if test="$anio ='2015' and $mes &gt;='03'">
								<xsl:choose>
									<xsl:when test="montoIce != ''">
										<montoIce>
											<xsl:value-of select="format-number(montoIce, '#0.00')"/>
										</montoIce>
									</xsl:when>
									<xsl:otherwise>
										<montoIce>0.00</montoIce>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
							<valorRetIva>
								<xsl:value-of select="format-number(valorRetIva, '#0.00')"/>
							</valorRetIva>
							<valorRetRenta>
								<xsl:value-of select="format-number(valorRetRenta, '#0.00')"/>
							</valorRetRenta>
						</detalleVentas>
					</xsl:for-each>
				</ventas>
			</xsl:if>
			<xsl:if test="ventasEstablecimiento">
				<ventasEstablecimiento>
					<xsl:for-each select="ventasEstablecimiento/ventaEst">
						<ventaEst>
							<xsl:copy-of select="codEstab"/>
							<xsl:copy-of select="ventasEstab"/>
						</ventaEst>
					</xsl:for-each>
				</ventasEstablecimiento>
			</xsl:if>
			<xsl:if test="exportaciones">
				<xsl:copy-of select="exportaciones"/>
			</xsl:if>
			<xsl:if test="recap">
				<xsl:copy-of select="recap"/>
			</xsl:if>
			<xsl:if test="fideicomisos">
				<xsl:copy-of select="fideicomisos"/>
			</xsl:if>
			<xsl:if test="anulados">
				<xsl:copy-of select="anulados"/>
			</xsl:if>
			<xsl:if test="rendFinancieros">
				<xsl:copy-of select="rendFinancieros"/>
			</xsl:if>
		</iva>
	</xsl:template>
</xsl:stylesheet>